<?php
// Run: php /path/to/cron/retry_vendings.php
// Cron: */5 * * * * php /path/to/cron/retry_vendings.php

if (php_sapi_name() !== 'cli') {
    die('CLI only');
}

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/DB.php';
require_once __DIR__ . '/../includes/VendingService.php';
require_once __DIR__ . '/../includes/StronpowerService.php';
require_once __DIR__ . '/../includes/SMSService.php';

echo "[" . date('Y-m-d H:i:s') . "] Starting retry vendings...\n";

try {
    $results = VendingService::retryFailed();
    
    $success = 0;
    $failed = 0;
    
    foreach ($results as $r) {
        if ($r['success']) {
            $success++;
            echo "  ✓ VR #{$r['vr_id']} - Payment #{$r['payment_id']}: SUCCESS\n";
        } else {
            $failed++;
            echo "  ✗ VR #{$r['vr_id']} - Payment #{$r['payment_id']}: FAILED - {$r['error']}\n";
        }
    }
    
    echo "\nTotal: " . count($results) . " | Success: $success | Failed: $failed\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "[" . date('Y-m-d H:i:s') . "] Done.\n";
