<?php
require_once '../../config/config.php';
require_once '../../includes/DB.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$db = DB::conn();

// Stats
$stats = [
    'clients' => $db->query("SELECT COUNT(*) as c FROM clients WHERE is_active=1")->fetch()['c'],
    'meters' => $db->query("SELECT COUNT(*) as c FROM meters WHERE is_active=1")->fetch()['c'],
    'customers' => $db->query("SELECT COUNT(*) as c FROM customers WHERE is_active=1")->fetch()['c'],
    'today_revenue' => $db->query("SELECT COALESCE(SUM(amount),0) as c FROM payments WHERE DATE(tx_date)=CURDATE() AND status='PROCESSED'")->fetch()['c'],
    'today_tx' => $db->query("SELECT COUNT(*) as c FROM payments WHERE DATE(tx_date)=CURDATE()")->fetch()['c'],
    'failed_vends' => $db->query("SELECT COUNT(*) as c FROM vending_requests WHERE status='FAILED' AND next_retry_at IS NOT NULL")->fetch()['c']
];

// Recent payments
$payments = $db->query("
    SELECT p.*, c.company_name, m.meter_id, cu.first_name, cu.last_name, t.token_value
    FROM payments p
    JOIN clients c ON p.client_id = c.id
    LEFT JOIN meters m ON p.meter_id = m.id
    LEFT JOIN customers cu ON p.customer_id = cu.id
    LEFT JOIN tokens t ON p.id = t.payment_id
    ORDER BY p.created_at DESC
    LIMIT 10
")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="flex">
        <?php include 'sidebar.php'; ?>
        
        <div class="main-content w-full">
            <div class="top-bar">
                <h1 class="text-blue">Dashboard</h1>
                <div class="flex items-center gap-4">
                    <span><?= htmlspecialchars($_SESSION['admin_name']) ?></span>
                    <a href="logout.php" class="btn btn-sm" style="background:#dc3545;color:white">Logout</a>
                    <button class="hamburger" onclick="toggleSidebar()"><i class="fas fa-bars"></i></button>  
                </div>
            </div>
            
            <div class="content">
                <div class="grid grid-cols-4 gap-4 mb-4">
                    <div class="stat-card">
                        <h3>Active Clients</h3>
                        <div class="value"><?= $stats['clients'] ?></div>
                    </div>
                    <div class="stat-card orange">
                        <h3>Active Meters</h3>
                        <div class="value"><?= $stats['meters'] ?></div>
                    </div>
                    <div class="stat-card">
                        <h3>Customers</h3>
                        <div class="value"><?= $stats['customers'] ?></div>
                    </div>
                    <div class="stat-card orange">
                        <h3>Today Revenue</h3>
                        <div class="value">KES <?= number_format($stats['today_revenue'], 2) ?></div>
                    </div>
                </div>
                
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div class="stat-card">
                        <h3>Today Transactions</h3>
                        <div class="value"><?= $stats['today_tx'] ?></div>
                    </div>
                    <div class="stat-card" style="border-left-color:<?= $stats['failed_vends'] > 0 ? '#dc3545' : '#28a745' ?>">
                        <h3>Failed Vendings</h3>
                        <div class="value"><?= $stats['failed_vends'] ?></div>
                        <?php if ($stats['failed_vends'] > 0): ?>
                            <small style="color:#dc3545">Pending retry</small>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="table-container">
                    <div class="table-header">
                        <h2>Recent Transactions</h2>
                    </div>
                    <table>
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Client</th>
                                <th>Meter</th>
                                <th>Customer</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Token</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($payments as $p): ?>
                                <tr>
                                    <td><?= date('Y-m-d H:i', strtotime($p['tx_date'])) ?></td>
                                    <td><?= htmlspecialchars($p['company_name']) ?></td>
                                    <td><?= htmlspecialchars($p['meter_id'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($p['first_name'].' '.$p['last_name']) ?></td>
                                    <td>KES <?= number_format($p['amount'], 2) ?></td>
                                    <td>
                                        <?php
                                        $badgeClass = [
                                            'PROCESSED' => 'badge-success',
                                            'PENDING' => 'badge-warning',
                                            'FAILED' => 'badge-danger'
                                        ][$p['status']] ?? 'badge-info';
                                        ?>
                                        <span class="badge <?= $badgeClass ?>"><?= $p['status'] ?></span>
                                    </td>
                                    <td>
                                        <?php if ($p['token_value']): ?>
                                            <code style="font-size:0.75rem"><?= htmlspecialchars($p['token_value']) ?></code>
                                        <?php else: ?>
                                            <span class="badge badge-warning">Pending</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <script>
function toggleSidebar() {
    document.querySelector('.sidebar').classList.toggle('active');
}
</script>
    <script>
function toggleSidebar() {
    document.querySelector('.sidebar').classList.toggle('active');
}
</script>
</body>
</html>
