<?php
require_once '../../config/config.php';
require_once '../../includes/DB.php';

if (isset($_SESSION['client_user_id'])) {
    header('Location: index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    $stmt = DB::conn()->prepare("
        SELECT cu.id, cu.username, cu.password, cu.full_name, cu.client_id,
               c.company_name, c.is_active as client_active
        FROM client_users cu
        JOIN clients c ON cu.client_id = c.id
        WHERE cu.username = ? AND cu.is_active = 1
    ");
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password'])) {
        if (!$user['client_active']) {
            $error = 'Client account is suspended';
        } else {
            $_SESSION['client_user_id'] = $user['id'];
            $_SESSION['client_id'] = $user['client_id'];
            $_SESSION['client_name'] = $user['full_name'];
            $_SESSION['company_name'] = $user['company_name'];
            header('Location: index.php');
            exit;
        }
    } else {
        $error = 'Invalid credentials';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Client Login - Water Vending</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        body { display: flex; align-items: center; justify-content: center; min-height: 100vh; background: linear-gradient(135deg, #f78510 0%, #1b405f 100%); }
        .login-box { background: white; padding: 2.5rem; border-radius: 12px; width: 100%; max-width: 400px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); }
        .login-box h1 { color: #1b405f; margin-bottom: 0.5rem; font-size: 1.75rem; }
        .login-box p { color: #545454; margin-bottom: 1.5rem; font-size: 0.875rem; }
    </style>
</head>
<body>
    <div class="login-box">
        <h1>Water Vending System</h1>
        <p>Client Portal</p>
        
        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label>Username</label>
                <input type="text" name="username" required autofocus>
            </div>
            
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" required>
            </div>
            
            <button type="submit" class="btn btn-orange w-full">Login</button>
        </form>
        
        <div class="text-center mt-4">
            <a href="../admin/login.php" style="color: #1b405f; text-decoration: none;">Admin Portal →</a>
        </div>
    </div>
    <script>
function toggleSidebar() {
    document.querySelector('.sidebar').classList.toggle('active');
}
</script>
</body>
</html>